{
  'target_defaults': {
    'default_configurations': 'Release',
    'configurations': {
      # Don't define DEBUG, it conflicts with the FILE_FLAGS enum.
      'Debug': {
        'defines!': [ 'DEBUG', 'NDEBUG' ],
      },
      'Release': {
        'defines!': [ 'DEBUG' ],
        'defines': [ 'NDEBUG' ],
      },
    },
  },
  'variables': {
    'lief_sources': [
      # Root
      'src/Object.cpp',
      'src/endianness_support.cpp',
      'src/Visitor.cpp',
      'src/errors.cpp',
      'src/hash_stream.cpp',
      'src/internal_utils.cpp',
      'src/iostream.cpp',
      'src/json_api.cpp',
      'src/logging.cpp',
      'src/paging.cpp',
      'src/utils.cpp',
      'src/range.cpp',
      'src/visitors/hash.cpp',
      # BinaryStream
      'src/BinaryStream/ASN1Reader.cpp',
      'src/BinaryStream/BinaryStream.cpp',
      'src/BinaryStream/FileStream.cpp',
      'src/BinaryStream/MemoryStream.cpp',
      'src/BinaryStream/SpanStream.cpp',
      'src/BinaryStream/VectorStream.cpp',
      # Abstract
      'src/Abstract/Binary.cpp',
      'src/Abstract/Symbol.cpp',
      'src/Abstract/Header.cpp',
      'src/Abstract/Section.cpp',
      'src/Abstract/Parser.cpp',
      'src/Abstract/Relocation.cpp',
      'src/Abstract/Function.cpp',
      'src/Abstract/hash.cpp',
      'src/Abstract/json_api.cpp',
      'src/Abstract/debug_info.cpp',
      # Platforms
      'src/platforms/android/version.cpp',
      # ELF core
      'src/ELF/Binary.cpp',
      'src/ELF/Builder.cpp',
      'src/ELF/endianness_support.cpp',
      'src/ELF/DataHandler/Handler.cpp',
      'src/ELF/DataHandler/Node.cpp',
      'src/ELF/DynamicEntry.cpp',
      'src/ELF/DynamicEntryArray.cpp',
      'src/ELF/DynamicEntryFlags.cpp',
      'src/ELF/DynamicEntryLibrary.cpp',
      'src/ELF/DynamicEntryRpath.cpp',
      'src/ELF/DynamicEntryRunPath.cpp',
      'src/ELF/DynamicSharedObject.cpp',
      'src/ELF/EnumToString.cpp',
      'src/ELF/GnuHash.cpp',
      'src/ELF/Header.cpp',
      'src/ELF/Layout.cpp',
      'src/ELF/Note.cpp',
      'src/ELF/Parser.cpp',
      'src/ELF/ProcessorFlags.cpp',
      'src/ELF/Relocation.cpp',
      'src/ELF/RelocationSizes.cpp',
      'src/ELF/RelocationStrings.cpp',
      'src/ELF/Section.cpp',
      'src/ELF/Segment.cpp',
      'src/ELF/Symbol.cpp',
      'src/ELF/SymbolVersion.cpp',
      'src/ELF/SymbolVersionAux.cpp',
      'src/ELF/SymbolVersionAuxRequirement.cpp',
      'src/ELF/SymbolVersionDefinition.cpp',
      'src/ELF/SymbolVersionRequirement.cpp',
      'src/ELF/SysvHash.cpp',
      'src/ELF/hash.cpp',
      'src/ELF/utils.cpp',
      'src/ELF/json_api.cpp',
      # ELF NoteDetails
      'src/ELF/NoteDetails/NoteAbi.cpp',
      'src/ELF/NoteDetails/AndroidIdent.cpp',
      'src/ELF/NoteDetails/NoteGnuProperty.cpp',
      'src/ELF/NoteDetails/QNXStack.cpp',
      'src/ELF/NoteDetails/core/CoreAuxv.cpp',
      'src/ELF/NoteDetails/core/CoreFile.cpp',
      'src/ELF/NoteDetails/core/CorePrPsInfo.cpp',
      'src/ELF/NoteDetails/core/CorePrStatus.cpp',
      'src/ELF/NoteDetails/core/CoreSigInfo.cpp',
      'src/ELF/NoteDetails/properties/AArch64Feature.cpp',
      'src/ELF/NoteDetails/properties/AArch64PAuth.cpp',
      'src/ELF/NoteDetails/properties/StackSize.cpp',
      'src/ELF/NoteDetails/properties/X86Feature.cpp',
      'src/ELF/NoteDetails/properties/X86ISA.cpp',
      # PE core
      'src/PE/Binary.cpp',
      'src/PE/Builder.cpp',
      'src/PE/CodeIntegrity.cpp',
      'src/PE/CodePage.cpp',
      'src/PE/DataDirectory.cpp',
      'src/PE/DelayImport.cpp',
      'src/PE/DelayImportEntry.cpp',
      'src/PE/DosHeader.cpp',
      'src/PE/EnumToString.cpp',
      'src/PE/ExceptionInfo.cpp',
      'src/PE/Export.cpp',
      'src/PE/ExportEntry.cpp',
      'src/PE/Factory.cpp',
      'src/PE/Header.cpp',
      'src/PE/Import.cpp',
      'src/PE/ImportEntry.cpp',
      'src/PE/OptionalHeader.cpp',
      'src/PE/Parser.cpp',
      'src/PE/ParserConfig.cpp',
      'src/PE/Relocation.cpp',
      'src/PE/RelocationEntry.cpp',
      'src/PE/ResourceData.cpp',
      'src/PE/ResourceDirectory.cpp',
      'src/PE/ResourceNode.cpp',
      'src/PE/ResourcesManager.cpp',
      'src/PE/RichEntry.cpp',
      'src/PE/RichHeader.cpp',
      'src/PE/Section.cpp',
      'src/PE/TLS.cpp',
      'src/PE/checksum.cpp',
      'src/PE/endianness_support.cpp',
      'src/PE/hash.cpp',
      'src/PE/json_api.cpp',
      'src/PE/layout_check.cpp',
      'src/PE/utils.cpp',
      # PE signature
      'src/PE/signature/Attribute.cpp',
      'src/PE/signature/ContentInfo.cpp',
      'src/PE/signature/GenericContent.cpp',
      'src/PE/signature/OIDToString.cpp',
      'src/PE/signature/PKCS9TSTInfo.cpp',
      'src/PE/signature/RsaInfo.cpp',
      'src/PE/signature/Signature.cpp',
      'src/PE/signature/SignatureParser.cpp',
      'src/PE/signature/SignerInfo.cpp',
      'src/PE/signature/SpcIndirectData.cpp',
      'src/PE/signature/x509.cpp',
      'src/PE/signature/attributes/ContentType.cpp',
      'src/PE/signature/attributes/GenericType.cpp',
      'src/PE/signature/attributes/MsCounterSign.cpp',
      'src/PE/signature/attributes/MsSpcNestedSignature.cpp',
      'src/PE/signature/attributes/MsSpcStatementType.cpp',
      'src/PE/signature/attributes/MsManifestBinaryID.cpp',
      'src/PE/signature/attributes/PKCS9AtSequenceNumber.cpp',
      'src/PE/signature/attributes/PKCS9CounterSignature.cpp',
      'src/PE/signature/attributes/PKCS9MessageDigest.cpp',
      'src/PE/signature/attributes/PKCS9SigningTime.cpp',
      'src/PE/signature/attributes/SpcSpOpusInfo.cpp',
      'src/PE/signature/attributes/SpcRelaxedPeMarkerCheck.cpp',
      'src/PE/signature/attributes/SigningCertificateV2.cpp',
      # PE LoadConfigurations
      'src/PE/LoadConfigurations/EnclaveConfiguration.cpp',
      'src/PE/LoadConfigurations/EnclaveImport.cpp',
      'src/PE/LoadConfigurations/LoadConfiguration.cpp',
      'src/PE/LoadConfigurations/VolatileMetadata.cpp',
      'src/PE/LoadConfigurations/CHPEMetadata/Metadata.cpp',
      'src/PE/LoadConfigurations/CHPEMetadata/MetadataARM64.cpp',
      'src/PE/LoadConfigurations/CHPEMetadata/MetadataX86.cpp',
      'src/PE/LoadConfigurations/DynamicRelocation/DynamicFixup.cpp',
      'src/PE/LoadConfigurations/DynamicRelocation/DynamicFixupARM64Kernel.cpp',
      'src/PE/LoadConfigurations/DynamicRelocation/DynamicFixupARM64X.cpp',
      'src/PE/LoadConfigurations/DynamicRelocation/DynamicFixupControlTransfer.cpp',
      'src/PE/LoadConfigurations/DynamicRelocation/DynamicFixupGeneric.cpp',
      'src/PE/LoadConfigurations/DynamicRelocation/DynamicRelocationBase.cpp',
      'src/PE/LoadConfigurations/DynamicRelocation/DynamicRelocationV1.cpp',
      'src/PE/LoadConfigurations/DynamicRelocation/DynamicRelocationV2.cpp',
      'src/PE/LoadConfigurations/DynamicRelocation/FunctionOverride.cpp',
      'src/PE/LoadConfigurations/DynamicRelocation/FunctionOverrideInfo.cpp',
      # PE debug/exceptions
      'src/PE/debug/CodeView.cpp',
      'src/PE/debug/CodeViewPDB.cpp',
      'src/PE/debug/Debug.cpp',
      'src/PE/debug/ExDllCharacteristics.cpp',
      'src/PE/debug/FPO.cpp',
      'src/PE/debug/PDBChecksum.cpp',
      'src/PE/debug/Pogo.cpp',
      'src/PE/debug/PogoEntry.cpp',
      'src/PE/debug/Repro.cpp',
      'src/PE/debug/VCFeature.cpp',
      'src/PE/exceptions_info/RuntimeFunctionX64.cpp',
      'src/PE/exceptions_info/RuntimeFunctionAArch64.cpp',
      'src/PE/exceptions_info/UnwindCodeX64.cpp',
      'src/PE/exceptions_info/UnwindAArch64Decoder.cpp',
      'src/PE/exceptions_info/AArch64/PackedFunction.cpp',
      'src/PE/exceptions_info/AArch64/UnpackedFunction.cpp',
      # PE resources
      'src/PE/resources/AcceleratorCodes.cpp',
      'src/PE/resources/ResourceAccelerator.cpp',
      'src/PE/resources/ResourceDialog.cpp',
      'src/PE/resources/ResourceDialogExtended.cpp',
      'src/PE/resources/ResourceDialogRegular.cpp',
      'src/PE/resources/ResourceIcon.cpp',
      'src/PE/resources/ResourceStringFileInfo.cpp',
      'src/PE/resources/ResourceStringTable.cpp',
      'src/PE/resources/ResourceVar.cpp',
      'src/PE/resources/ResourceVarFileInfo.cpp',
      'src/PE/resources/ResourceVersion.cpp',
      # COFF (required by PE)
      'src/COFF/Binary.cpp',
      'src/COFF/utils.cpp',
      'src/COFF/Parser.cpp',
      'src/COFF/Header.cpp',
      'src/COFF/Section.cpp',
      'src/COFF/Relocation.cpp',
      'src/COFF/BigObjHeader.cpp',
      'src/COFF/RegularHeader.cpp',
      'src/COFF/Symbol.cpp',
      'src/COFF/AuxiliarySymbol.cpp',
      'src/COFF/AuxiliarySymbols/AuxiliarybfAndefSymbol.cpp',
      'src/COFF/AuxiliarySymbols/AuxiliaryCLRToken.cpp',
      'src/COFF/AuxiliarySymbols/AuxiliaryFile.cpp',
      'src/COFF/AuxiliarySymbols/AuxiliaryFunctionDefinition.cpp',
      'src/COFF/AuxiliarySymbols/AuxiliarySectionDefinition.cpp',
      'src/COFF/AuxiliarySymbols/AuxiliaryWeakExternal.cpp',
      # Mach-O
      'src/MachO/AtomInfo.cpp',
      'src/MachO/Binary.cpp',
      'src/MachO/BinaryParser.cpp',
      'src/MachO/BindingInfo.cpp',
      'src/MachO/BindingInfoIterator.cpp',
      'src/MachO/BuildToolVersion.cpp',
      'src/MachO/BuildVersion.cpp',
      'src/MachO/Builder.cpp',
      'src/MachO/ChainedBindingInfo.cpp',
      'src/MachO/ChainedBindingInfoList.cpp',
      'src/MachO/ChainedFixup.cpp',
      'src/MachO/ChainedPointerAnalysis.cpp',
      'src/MachO/CodeSignature.cpp',
      'src/MachO/CodeSignatureDir.cpp',
      'src/MachO/DataCodeEntry.cpp',
      'src/MachO/DataInCode.cpp',
      'src/MachO/DyldBindingInfo.cpp',
      'src/MachO/DyldChainedFixups.cpp',
      'src/MachO/DyldChainedFixupsCreator.cpp',
      'src/MachO/DyldChainedFormat.cpp',
      'src/MachO/DyldEnvironment.cpp',
      'src/MachO/DyldExportsTrie.cpp',
      'src/MachO/DyldInfo.cpp',
      'src/MachO/DylibCommand.cpp',
      'src/MachO/DylinkerCommand.cpp',
      'src/MachO/DynamicSymbolCommand.cpp',
      'src/MachO/EncryptionInfo.cpp',
      'src/MachO/EnumToString.cpp',
      'src/MachO/ExportInfo.cpp',
      'src/MachO/FatBinary.cpp',
      'src/MachO/FilesetCommand.cpp',
      'src/MachO/FunctionStarts.cpp',
      'src/MachO/FunctionVariants.cpp',
      'src/MachO/FunctionVariantFixups.cpp',
      'src/MachO/Header.cpp',
      'src/MachO/IndirectBindingInfo.cpp',
      'src/MachO/LinkEdit.cpp',
      'src/MachO/LinkerOptHint.cpp',
      'src/MachO/LoadCommand.cpp',
      'src/MachO/MainCommand.cpp',
      'src/MachO/NoteCommand.cpp',
      'src/MachO/Parser.cpp',
      'src/MachO/ParserConfig.cpp',
      'src/MachO/RPathCommand.cpp',
      'src/MachO/Relocation.cpp',
      'src/MachO/RelocationDyld.cpp',
      'src/MachO/RelocationFixup.cpp',
      'src/MachO/RelocationObject.cpp',
      'src/MachO/Routine.cpp',
      'src/MachO/Section.cpp',
      'src/MachO/SegmentCommand.cpp',
      'src/MachO/SegmentSplitInfo.cpp',
      'src/MachO/SourceVersion.cpp',
      'src/MachO/Stub.cpp',
      'src/MachO/SubClient.cpp',
      'src/MachO/SubFramework.cpp',
      'src/MachO/Symbol.cpp',
      'src/MachO/SymbolCommand.cpp',
      'src/MachO/ThreadCommand.cpp',
      'src/MachO/TrieNode.cpp',
      'src/MachO/TwoLevelHints.cpp',
      'src/MachO/UUIDCommand.cpp',
      'src/MachO/UnknownCommand.cpp',
      'src/MachO/VersionMin.cpp',
      'src/MachO/endianness_support.cpp',
      'src/MachO/exports_trie.cpp',
      'src/MachO/hash.cpp',
      'src/MachO/json_api.cpp',
      'src/MachO/layout_check.cpp',
      'src/MachO/utils.cpp',
      # Stubs when extended features are disabled
      'src/DWARF/dwarf.cpp',
      'src/PDB/pdb.cpp',
      'src/ObjC/objc.cpp',
      'src/dyld-shared-cache/dyldsc.cpp',
      'src/asm/asm.cpp',
    ],
    'lief_third_party_sources': [
      # mbedTLS sources (extracted and checked in under third-party)
      'third-party/mbedtls/library/aes.c',
      'third-party/mbedtls/library/aesce.c',
      'third-party/mbedtls/library/aesni.c',
      'third-party/mbedtls/library/aria.c',
      'third-party/mbedtls/library/asn1parse.c',
      'third-party/mbedtls/library/asn1write.c',
      'third-party/mbedtls/library/base64.c',
      'third-party/mbedtls/library/bignum.c',
      'third-party/mbedtls/library/bignum_core.c',
      'third-party/mbedtls/library/bignum_mod.c',
      'third-party/mbedtls/library/bignum_mod_raw.c',
      'third-party/mbedtls/library/block_cipher.c',
      'third-party/mbedtls/library/camellia.c',
      'third-party/mbedtls/library/ccm.c',
      'third-party/mbedtls/library/chacha20.c',
      'third-party/mbedtls/library/chachapoly.c',
      'third-party/mbedtls/library/cipher.c',
      'third-party/mbedtls/library/cipher_wrap.c',
      'third-party/mbedtls/library/cmac.c',
      'third-party/mbedtls/library/constant_time.c',
      'third-party/mbedtls/library/ctr_drbg.c',
      'third-party/mbedtls/library/debug.c',
      'third-party/mbedtls/library/des.c',
      'third-party/mbedtls/library/dhm.c',
      'third-party/mbedtls/library/ecdh.c',
      'third-party/mbedtls/library/ecdsa.c',
      'third-party/mbedtls/library/ecjpake.c',
      'third-party/mbedtls/library/ecp.c',
      'third-party/mbedtls/library/ecp_curves.c',
      'third-party/mbedtls/library/ecp_curves_new.c',
      'third-party/mbedtls/library/entropy.c',
      'third-party/mbedtls/library/entropy_poll.c',
      'third-party/mbedtls/library/error.c',
      'third-party/mbedtls/library/gcm.c',
      'third-party/mbedtls/library/hkdf.c',
      'third-party/mbedtls/library/hmac_drbg.c',
      'third-party/mbedtls/library/lmots.c',
      'third-party/mbedtls/library/lms.c',
      'third-party/mbedtls/library/md.c',
      'third-party/mbedtls/library/md5.c',
      'third-party/mbedtls/library/memory_buffer_alloc.c',
      'third-party/mbedtls/library/mps_reader.c',
      'third-party/mbedtls/library/mps_trace.c',
      'third-party/mbedtls/library/net_sockets.c',
      'third-party/mbedtls/library/nist_kw.c',
      'third-party/mbedtls/library/oid.c',
      'third-party/mbedtls/library/padlock.c',
      'third-party/mbedtls/library/pem.c',
      'third-party/mbedtls/library/pk.c',
      'third-party/mbedtls/library/pk_ecc.c',
      'third-party/mbedtls/library/pk_wrap.c',
      'third-party/mbedtls/library/pkcs12.c',
      'third-party/mbedtls/library/pkcs5.c',
      'third-party/mbedtls/library/pkcs7.c',
      'third-party/mbedtls/library/pkparse.c',
      'third-party/mbedtls/library/pkwrite.c',
      'third-party/mbedtls/library/platform.c',
      'third-party/mbedtls/library/platform_util.c',
      'third-party/mbedtls/library/poly1305.c',
      'third-party/mbedtls/library/psa_crypto.c',
      'third-party/mbedtls/library/psa_crypto_aead.c',
      'third-party/mbedtls/library/psa_crypto_cipher.c',
      'third-party/mbedtls/library/psa_crypto_client.c',
      'third-party/mbedtls/library/psa_crypto_driver_wrappers_no_static.c',
      'third-party/mbedtls/library/psa_crypto_ecp.c',
      'third-party/mbedtls/library/psa_crypto_ffdh.c',
      'third-party/mbedtls/library/psa_crypto_hash.c',
      'third-party/mbedtls/library/psa_crypto_mac.c',
      'third-party/mbedtls/library/psa_crypto_pake.c',
      'third-party/mbedtls/library/psa_crypto_rsa.c',
      'third-party/mbedtls/library/psa_crypto_se.c',
      'third-party/mbedtls/library/psa_crypto_slot_management.c',
      'third-party/mbedtls/library/psa_crypto_storage.c',
      'third-party/mbedtls/library/psa_its_file.c',
      'third-party/mbedtls/library/psa_util.c',
      'third-party/mbedtls/library/ripemd160.c',
      'third-party/mbedtls/library/rsa.c',
      'third-party/mbedtls/library/rsa_alt_helpers.c',
      'third-party/mbedtls/library/sha1.c',
      'third-party/mbedtls/library/sha256.c',
      'third-party/mbedtls/library/sha3.c',
      'third-party/mbedtls/library/sha512.c',
      'third-party/mbedtls/library/ssl_cache.c',
      'third-party/mbedtls/library/ssl_ciphersuites.c',
      'third-party/mbedtls/library/ssl_client.c',
      'third-party/mbedtls/library/ssl_cookie.c',
      'third-party/mbedtls/library/ssl_debug_helpers_generated.c',
      'third-party/mbedtls/library/ssl_msg.c',
      'third-party/mbedtls/library/ssl_ticket.c',
      'third-party/mbedtls/library/ssl_tls.c',
      'third-party/mbedtls/library/ssl_tls12_client.c',
      'third-party/mbedtls/library/ssl_tls12_server.c',
      'third-party/mbedtls/library/ssl_tls13_client.c',
      'third-party/mbedtls/library/ssl_tls13_generic.c',
      'third-party/mbedtls/library/ssl_tls13_keys.c',
      'third-party/mbedtls/library/ssl_tls13_server.c',
      'third-party/mbedtls/library/threading.c',
      'third-party/mbedtls/library/timing.c',
      'third-party/mbedtls/library/version.c',
      'third-party/mbedtls/library/version_features.c',
      'third-party/mbedtls/library/x509.c',
      'third-party/mbedtls/library/x509_create.c',
      'third-party/mbedtls/library/x509_crl.c',
      'third-party/mbedtls/library/x509_crt.c',
      'third-party/mbedtls/library/x509_csr.c',
      'third-party/mbedtls/library/x509write.c',
      'third-party/mbedtls/library/x509write_crt.c',
      'third-party/mbedtls/library/x509write_csr.c',
    ]
  },
  'targets': [
    {
      'target_name': 'liblief',
      'toolsets': ['host', 'target'],
      'type': 'static_library',
      'includes': [],
      'include_dirs': [
        '.',
        #include <LIEF/third-party/internal/expected.hpp>
        #include <LIEF/third-party/internal/span.hpp>
        'include',
        'src',
        # Extracted third-party (checked into source by update script)
        #include "mbedtls/private_access.h"
        'third-party/mbedtls/include',
        'third-party/mbedtls/library',
        #include "spdlog/fmt/..."
        'third-party/spdlog/include',
        #include <frozen/map.h>
        'third-party/frozen/include',
        #include <internal/utfcpp/utf8/unchecked.h>
        "include/LIEF/third-party",
        #include "utf8/unchecked.h"
        "include/LIEF/third-party/internal",
      ],
      'direct_dependent_settings': {
        'include_dirs': [ 'include' ],
      },
      'defines': [
        'LIEF_STATIC',
        'testtttt'
        'MBEDTLS_CONFIG_FILE="config/mbedtls/config.h"',
        'MBEDTLS_NO_PLATFORM_ENTROPY',
        'SPDLOG_DISABLE_DEFAULT_LOGGER',
        'SPDLOG_NO_EXCEPTIONS',
        'SPDLOG_FUNCTION=""',
        '_GLIBCXX_USE_CXX11_ABI=1',
      ],
      'cflags': [
        '-fPIC'
      ],
      # We need c++17 to compile without std::format and avoid conflicts with spdlog.
      'msvs_settings': {
        'VCCLCompilerTool': {
          'LanguageStandard': 'stdcpp17',
        },
      },
      'cflags_cc': [
        '-std=gnu++17',
        '-fPIC',
        '-fvisibility=hidden',
        '-fvisibility-inlines-hidden',
        '-Wall',
        '-Wextra',
        '-Wpedantic',
        '-Wno-expansion-to-defined',
        '-Werror=return-type',
        '-fno-exceptions'
      ],
      'xcode_settings': {
        'OTHER_CPLUSPLUSFLAGS': [
          '-std=gnu++17',
          '-fPIC',
          '-fvisibility=hidden',
          '-fvisibility-inlines-hidden',
          '-Wall',
          '-Wextra',
          '-Wpedantic',
          '-Wno-expansion-to-defined',
          '-Werror=return-type',
          '-fno-exceptions'
        ],
      },
      'sources': [
        '<@(lief_sources)',
        '<@(lief_third_party_sources)',
      ],
    }
  ]
}
