var keyData = {
  'ML-DSA-44': {
    privateUsages: ['sign'],
    publicUsages: ['verify'],
    pkcs8: new Uint8Array([
      48, 52, 2, 1, 0, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 3, 17, 4, 34,
      128, 32, 153, 21, 95, 99, 48, 150, 218, 124, 190, 8, 122, 137, 72, 184,
      79, 118, 123, 16, 249, 1, 200, 35, 194, 64, 177, 221, 43, 200, 112, 5,
      201, 62,
    ]),
    spki: new Uint8Array([
      48, 130, 5, 50, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 3, 17, 3, 130, 5,
      33, 0, 85, 152, 213, 68, 198, 20, 177, 84, 200, 188, 33, 104, 36, 161,
      193, 127, 226, 151, 48, 107, 122, 191, 89, 86, 188, 3, 245, 199, 18, 79,
      168, 192, 218, 218, 223, 227, 84, 133, 41, 187, 9, 183, 14, 222, 155, 137,
      84, 111, 138, 97, 234, 152, 52, 15, 163, 47, 227, 218, 19, 20, 229, 93,
      99, 252, 155, 213, 30, 241, 158, 211, 213, 191, 155, 73, 211, 145, 59,
      194, 75, 140, 3, 161, 149, 139, 48, 172, 155, 172, 120, 234, 142, 79, 78,
      116, 215, 184, 50, 182, 162, 192, 93, 221, 179, 216, 70, 186, 92, 93, 51,
      190, 61, 173, 105, 206, 9, 208, 52, 54, 208, 252, 115, 176, 146, 118, 23,
      0, 5, 41, 151, 121, 241, 246, 193, 206, 212, 160, 181, 7, 99, 220, 78, 96,
      123, 142, 35, 107, 37, 218, 138, 139, 228, 207, 166, 132, 87, 36, 116,
      251, 174, 10, 41, 196, 171, 26, 212, 90, 213, 223, 141, 87, 232, 59, 46,
      173, 16, 247, 173, 4, 219, 165, 234, 8, 217, 233, 163, 13, 10, 160, 22,
      87, 232, 2, 9, 92, 177, 35, 67, 55, 104, 51, 204, 231, 81, 209, 62, 31,
      117, 56, 141, 78, 109, 148, 118, 191, 93, 193, 59, 30, 88, 237, 19, 169,
      14, 11, 150, 102, 215, 144, 69, 246, 32, 159, 110, 49, 75, 78, 225, 121,
      184, 206, 234, 126, 171, 164, 43, 237, 244, 63, 83, 70, 136, 213, 244,
      121, 184, 34, 201, 249, 95, 64, 165, 99, 14, 195, 231, 18, 121, 20, 156,
      80, 231, 133, 197, 0, 94, 195, 22, 251, 255, 174, 213, 103, 75, 88, 58,
      138, 66, 37, 85, 162, 15, 242, 29, 49, 147, 191, 163, 170, 109, 195, 22,
      63, 197, 149, 117, 100, 36, 81, 115, 203, 126, 62, 86, 103, 193, 182, 69,
      238, 233, 162, 62, 248, 132, 158, 212, 208, 187, 127, 212, 198, 169, 245,
      26, 153, 28, 207, 85, 65, 145, 200, 23, 196, 38, 64, 49, 54, 233, 185, 72,
      156, 86, 230, 127, 152, 108, 184, 240, 109, 8, 103, 228, 206, 142, 73, 74,
      214, 52, 182, 203, 82, 201, 175, 188, 111, 42, 232, 8, 177, 131, 47, 237,
      92, 120, 210, 124, 48, 185, 215, 137, 36, 70, 162, 164, 119, 0, 155, 20,
      57, 33, 27, 220, 77, 254, 233, 190, 106, 135, 21, 194, 57, 238, 95, 162,
      78, 164, 33, 210, 215, 43, 100, 96, 232, 87, 19, 43, 65, 240, 183, 17,
      131, 247, 97, 241, 7, 111, 159, 40, 252, 45, 228, 76, 71, 46, 85, 181, 54,
      41, 135, 162, 144, 227, 128, 121, 173, 207, 119, 54, 19, 197, 23, 231,
      176, 125, 190, 32, 76, 60, 34, 24, 160, 42, 73, 190, 124, 99, 5, 9, 214,
      6, 220, 177, 206, 79, 222, 10, 142, 250, 63, 179, 67, 21, 159, 57, 126,
      239, 28, 238, 240, 107, 79, 185, 174, 232, 168, 146, 128, 229, 119, 19,
      21, 33, 239, 193, 42, 178, 152, 124, 24, 203, 131, 193, 93, 162, 2, 208,
      231, 20, 203, 232, 47, 54, 114, 255, 236, 97, 99, 156, 15, 160, 75, 60,
      111, 59, 35, 25, 230, 43, 91, 170, 161, 74, 70, 179, 180, 251, 71, 197,
      240, 104, 42, 39, 202, 206, 12, 115, 249, 138, 55, 252, 216, 61, 185, 121,
      76, 137, 172, 166, 88, 92, 130, 18, 52, 67, 13, 187, 49, 147, 212, 77, 74,
      56, 59, 123, 99, 205, 36, 137, 96, 111, 148, 121, 157, 2, 83, 246, 86,
      156, 152, 98, 172, 77, 244, 214, 225, 184, 240, 121, 144, 56, 213, 161,
      43, 67, 4, 161, 104, 202, 91, 134, 247, 108, 24, 46, 187, 63, 216, 50,
      125, 120, 17, 216, 22, 228, 156, 253, 7, 180, 15, 130, 180, 72, 71, 169,
      3, 236, 247, 11, 170, 32, 76, 236, 225, 133, 250, 20, 235, 200, 143, 89,
      25, 158, 49, 158, 164, 213, 221, 81, 120, 241, 150, 210, 19, 79, 165, 24,
      35, 170, 182, 242, 255, 143, 171, 148, 140, 41, 207, 186, 98, 224, 16,
      152, 224, 38, 110, 175, 169, 111, 132, 201, 178, 114, 25, 196, 50, 149,
      158, 193, 180, 101, 183, 92, 109, 131, 102, 119, 123, 78, 107, 223, 4, 1,
      206, 140, 130, 237, 205, 36, 18, 180, 197, 154, 26, 236, 140, 173, 230,
      101, 35, 189, 121, 104, 21, 75, 81, 224, 186, 212, 81, 107, 66, 244, 235,
      64, 90, 206, 39, 44, 43, 162, 187, 63, 229, 217, 154, 185, 157, 24, 125,
      252, 91, 136, 59, 47, 182, 200, 73, 19, 137, 132, 81, 16, 234, 227, 210,
      32, 16, 160, 188, 250, 27, 190, 164, 53, 244, 219, 199, 177, 146, 117, 50,
      99, 72, 235, 37, 154, 72, 51, 203, 61, 39, 230, 34, 132, 117, 217, 167,
      201, 42, 17, 76, 72, 103, 172, 93, 169, 29, 76, 88, 178, 226, 32, 53, 190,
      60, 210, 132, 113, 198, 26, 70, 179, 47, 34, 184, 88, 178, 208, 1, 196,
      89, 136, 167, 33, 38, 9, 255, 89, 202, 27, 93, 229, 100, 192, 24, 234,
      200, 186, 125, 231, 212, 188, 11, 29, 51, 189, 70, 147, 176, 231, 81, 16,
      114, 152, 159, 21, 124, 185, 208, 50, 74, 211, 113, 207, 35, 54, 173, 205,
      133, 52, 167, 199, 87, 158, 120, 33, 204, 163, 146, 233, 21, 61, 28, 102,
      48, 232, 184, 15, 219, 238, 240, 215, 222, 239, 3, 110, 180, 95, 103, 147,
      236, 10, 57, 195, 159, 231, 50, 92, 145, 165, 44, 204, 121, 187, 9, 210,
      80, 86, 251, 169, 132, 236, 248, 23, 207, 222, 227, 13, 53, 1, 88, 69,
      105, 13, 238, 202, 251, 194, 245, 14, 38, 1, 245, 157, 212, 162, 182, 217,
      230, 115, 139, 175, 219, 199, 74, 124, 186, 158, 3, 220, 87, 220, 177, 85,
      13, 58, 168, 223, 6, 238, 156, 80, 121, 44, 166, 176, 0, 48, 98, 70, 93,
      78, 50, 192, 16, 186, 2, 233, 105, 105, 120, 195, 17, 100, 141, 214, 158,
      144, 63, 4, 88, 190, 101, 209, 55, 119, 46, 128, 117, 225, 121, 204, 195,
      19, 61, 170, 116, 251, 225, 230, 28, 27, 249, 84, 195, 224, 190, 60, 212,
      83, 3, 148, 204, 4, 103, 50, 233, 175, 207, 47, 51, 216, 79, 251, 150, 81,
      171, 7, 145, 55, 188, 187, 217, 200, 155, 246, 85, 42, 123, 18, 112, 192,
      116, 163, 40, 187, 132, 192, 210, 188, 106, 117, 217, 185, 183, 202, 33,
      11, 205, 10, 61, 52, 15, 66, 131, 121, 112, 26, 96, 166, 241, 1, 68, 206,
      80, 92, 132, 83, 89, 126, 135, 157, 4, 202, 16, 5, 131, 112, 62, 56, 234,
      176, 213, 119, 205, 203, 17, 106, 156, 117, 251, 135, 21, 73, 219, 238, 3,
      88, 21, 71, 136, 118, 0, 7, 106, 151, 200, 221, 179, 206, 50, 198, 27,
      118, 181, 27, 85, 35, 248, 44, 57, 15, 221, 97, 121, 4, 167, 111, 182,
      207, 195, 52, 134, 195, 128, 173, 111, 98, 152, 29, 138, 197, 175, 171,
      247, 194, 20, 134, 209, 232, 94, 17, 203, 139, 30, 237, 187, 243, 16, 180,
      43, 105, 236, 66, 175, 170, 139, 24, 99, 28, 225, 141, 96, 250, 119, 0,
      111, 212, 34, 217, 42, 134, 88, 78, 76, 126, 169, 168, 59, 154, 93, 54,
      43, 161, 29, 111, 124, 59, 225, 52, 86, 147, 38, 151, 161, 36, 119, 204,
      164, 121, 46, 186, 65, 84, 70, 38, 15, 203, 48, 168, 235, 231, 30, 55, 95,
      36, 10, 20, 166, 109, 8, 18, 109, 251, 213, 82, 142, 240, 49, 249, 180,
      78, 69,
    ]),
    'raw-public': hexStringToUint8Array(
      '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'
    ),
    'raw-seed': new Uint8Array([
      153, 21, 95, 99, 48, 150, 218, 124, 190, 8, 122, 137, 72, 184, 79, 118,
      123, 16, 249, 1, 200, 35, 194, 64, 177, 221, 43, 200, 112, 5, 201, 62,
    ]),
    jwk: {
      priv: 'mRVfYzCW2ny-CHqJSLhPdnsQ-QHII8JAsd0ryHAFyT4',
      kty: 'AKP',
      alg: 'ML-DSA-44',
      pub: 'VZjVRMYUsVTIvCFoJKHBf-KXMGt6v1lWvAP1xxJPqMDa2t_jVIUpuwm3Dt6biVRvimHqmDQPoy_j2hMU5V1j_JvVHvGe09W_m0nTkTvCS4wDoZWLMKybrHjqjk9OdNe4MraiwF3ds9hGulxdM749rWnOCdA0NtD8c7CSdhcABSmXefH2wc7UoLUHY9xOYHuOI2sl2oqL5M-mhFckdPuuCinEqxrUWtXfjVfoOy6tEPetBNul6gjZ6aMNCqAWV-gCCVyxI0M3aDPM51HRPh91OI1ObZR2v13BOx5Y7ROpDguWZteQRfYgn24xS07hebjO6n6rpCvt9D9TRojV9Hm4Isn5X0ClYw7D5xJ5FJxQ54XFAF7DFvv_rtVnS1g6ikIlVaIP8h0xk7-jqm3DFj_FlXVkJFFzy34-VmfBtkXu6aI--ISe1NC7f9TGqfUamRzPVUGRyBfEJkAxNum5SJxW5n-YbLjwbQhn5M6OSUrWNLbLUsmvvG8q6Aixgy_tXHjSfDC514kkRqKkdwCbFDkhG9xN_um-aocVwjnuX6JOpCHS1ytkYOhXEytB8LcRg_dh8Qdvnyj8LeRMRy5VtTYph6KQ44B5rc93NhPFF-ewfb4gTDwiGKAqSb58YwUJ1gbcsc5P3gqO-j-zQxWfOX7vHO7wa0-5ruiokoDldxMVIe_BKrKYfBjLg8FdogLQ5xTL6C82cv_sYWOcD6BLPG87IxnmK1uqoUpGs7T7R8XwaConys4Mc_mKN_zYPbl5TImsplhcghI0Qw27MZPUTUo4O3tjzSSJYG-UeZ0CU_ZWnJhirE301uG48HmQONWhK0MEoWjKW4b3bBguuz_YMn14EdgW5Jz9B7QPgrRIR6kD7PcLqiBM7OGF-hTryI9ZGZ4xnqTV3VF48ZbSE0-lGCOqtvL_j6uUjCnPumLgEJjgJm6vqW-EybJyGcQylZ7BtGW3XG2DZnd7TmvfBAHOjILtzSQStMWaGuyMreZlI715aBVLUeC61FFrQvTrQFrOJywrors_5dmauZ0YffxbiDsvtshJE4mEURDq49IgEKC8-hu-pDX028exknUyY0jrJZpIM8s9J-YihHXZp8kqEUxIZ6xdqR1MWLLiIDW-PNKEccYaRrMvIrhYstABxFmIpyEmCf9Zyhtd5WTAGOrIun3n1LwLHTO9RpOw51EQcpifFXy50DJK03HPIzatzYU0p8dXnnghzKOS6RU9HGYw6LgP2-7w197vA260X2eT7Ao5w5_nMlyRpSzMebsJ0lBW-6mE7PgXz97jDTUBWEVpDe7K-8L1DiYB9Z3UorbZ5nOLr9vHSny6ngPcV9yxVQ06qN8G7pxQeSymsAAwYkZdTjLAELoC6WlpeMMRZI3WnpA_BFi-ZdE3dy6AdeF5zMMTPap0--HmHBv5VMPgvjzUUwOUzARnMumvzy8z2E_7llGrB5E3vLvZyJv2VSp7EnDAdKMou4TA0rxqddm5t8ohC80KPTQPQoN5cBpgpvEBRM5QXIRTWX6HnQTKEAWDcD446rDVd83LEWqcdfuHFUnb7gNYFUeIdgAHapfI3bPOMsYbdrUbVSP4LDkP3WF5BKdvts_DNIbDgK1vYpgdisWvq_fCFIbR6F4Ry4se7bvzELQraexCr6qLGGMc4Y1g-ncAb9Qi2SqGWE5MfqmoO5pdNiuhHW98O-E0VpMml6Ekd8ykeS66QVRGJg_LMKjr5x43XyQKFKZtCBJt-9VSjvAx-bRORQ',
    },
  },
  'ML-DSA-65': {
    privateUsages: ['sign'],
    publicUsages: ['verify'],
    pkcs8: new Uint8Array([
      48, 52, 2, 1, 0, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 3, 18, 4, 34,
      128, 32, 132, 164, 137, 75, 123, 70, 164, 178, 3, 156, 206, 16, 195, 26,
      133, 186, 176, 195, 102, 48, 254, 35, 29, 66, 103, 17, 67, 152, 38, 7,
      130, 139,
    ]),
    spki: new Uint8Array([
      48, 130, 7, 178, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 3, 18, 3, 130,
      7, 161, 0, 216, 177, 233, 60, 151, 24, 246, 66, 175, 161, 192, 118, 9,
      177, 87, 232, 5, 216, 49, 254, 251, 160, 51, 216, 250, 171, 229, 104, 149,
      117, 135, 107, 5, 239, 244, 167, 83, 57, 49, 153, 29, 135, 108, 138, 117,
      236, 120, 65, 89, 65, 17, 201, 127, 147, 246, 103, 238, 204, 25, 83, 240,
      29, 173, 127, 140, 1, 88, 40, 43, 134, 51, 19, 125, 131, 224, 50, 167, 82,
      20, 217, 215, 162, 41, 95, 215, 56, 130, 226, 177, 216, 20, 169, 133, 85,
      140, 9, 105, 172, 54, 121, 0, 87, 202, 18, 93, 96, 147, 103, 127, 164, 63,
      197, 97, 49, 230, 125, 53, 80, 64, 20, 239, 29, 90, 118, 102, 221, 177, 6,
      220, 220, 170, 107, 107, 18, 138, 125, 138, 70, 66, 60, 185, 232, 209, 4,
      100, 17, 118, 24, 181, 110, 241, 50, 250, 138, 209, 19, 84, 220, 61, 96,
      80, 128, 81, 101, 160, 9, 5, 53, 33, 112, 60, 59, 195, 79, 115, 190, 101,
      93, 56, 171, 146, 51, 82, 233, 66, 225, 226, 211, 72, 58, 9, 74, 222, 185,
      175, 211, 156, 164, 68, 188, 119, 46, 14, 64, 160, 13, 207, 60, 81, 68,
      108, 148, 59, 88, 88, 92, 88, 171, 249, 204, 160, 137, 222, 234, 168, 233,
      3, 86, 224, 174, 105, 224, 1, 177, 184, 230, 236, 30, 85, 249, 56, 105,
      211, 50, 83, 168, 139, 28, 175, 181, 22, 89, 166, 215, 152, 218, 184, 111,
      65, 24, 82, 71, 185, 100, 172, 66, 178, 6, 215, 164, 252, 56, 40, 198,
      207, 152, 110, 186, 207, 39, 235, 179, 38, 215, 88, 105, 109, 177, 130,
      91, 5, 223, 164, 78, 241, 176, 125, 197, 94, 100, 40, 214, 251, 239, 253,
      88, 154, 14, 75, 254, 94, 210, 86, 244, 51, 95, 168, 139, 213, 73, 87,
      151, 209, 150, 126, 88, 69, 251, 116, 157, 122, 96, 212, 206, 42, 218, 38,
      85, 184, 50, 246, 188, 35, 72, 60, 226, 155, 246, 86, 209, 110, 133, 161,
      129, 126, 80, 154, 238, 64, 64, 170, 156, 177, 225, 52, 87, 42, 88, 154,
      174, 246, 30, 84, 143, 221, 51, 27, 65, 60, 40, 22, 120, 42, 145, 34, 82,
      235, 79, 20, 215, 211, 231, 151, 108, 119, 53, 116, 190, 13, 139, 199,
      189, 84, 54, 186, 222, 90, 116, 253, 227, 207, 104, 209, 118, 42, 144, 94,
      22, 219, 198, 211, 216, 171, 75, 245, 61, 240, 157, 108, 81, 19, 238, 39,
      120, 210, 242, 63, 126, 6, 15, 18, 97, 232, 207, 184, 84, 239, 72, 115,
      90, 95, 112, 78, 45, 201, 13, 102, 208, 151, 146, 253, 153, 177, 115, 14,
      194, 184, 107, 118, 120, 63, 105, 89, 144, 60, 242, 80, 106, 32, 11, 204,
      170, 165, 221, 182, 31, 187, 159, 216, 118, 218, 207, 182, 107, 136, 211,
      162, 231, 196, 128, 83, 251, 192, 189, 149, 1, 245, 36, 146, 159, 11, 116,
      30, 191, 141, 182, 157, 227, 91, 88, 72, 224, 55, 195, 96, 245, 135, 249,
      142, 16, 229, 237, 27, 60, 2, 91, 138, 82, 197, 210, 40, 8, 123, 172, 202,
      207, 119, 199, 190, 102, 40, 141, 174, 93, 211, 219, 134, 105, 26, 103,
      100, 102, 62, 130, 224, 135, 173, 82, 224, 200, 213, 76, 211, 38, 181, 16,
      97, 99, 75, 14, 42, 162, 223, 237, 141, 1, 29, 140, 191, 146, 49, 236,
      179, 88, 202, 220, 124, 239, 231, 131, 101, 134, 111, 28, 54, 151, 172,
      67, 167, 113, 96, 204, 63, 76, 169, 95, 14, 175, 149, 189, 173, 39, 177,
      102, 23, 158, 102, 236, 224, 70, 203, 190, 132, 230, 136, 3, 28, 201, 131,
      148, 164, 219, 181, 208, 26, 239, 111, 86, 35, 102, 133, 114, 113, 180,
      184, 82, 180, 106, 124, 248, 126, 87, 177, 165, 176, 204, 128, 141, 179,
      141, 34, 119, 160, 57, 206, 168, 95, 197, 110, 79, 60, 48, 170, 125, 206,
      147, 137, 156, 85, 46, 7, 193, 228, 150, 22, 46, 147, 51, 153, 157, 248,
      151, 253, 114, 58, 126, 38, 127, 19, 225, 99, 183, 235, 175, 90, 166, 8,
      233, 141, 10, 85, 232, 147, 7, 20, 137, 240, 84, 231, 86, 134, 50, 212,
      201, 6, 253, 18, 150, 114, 160, 140, 2, 254, 189, 152, 14, 68, 110, 50,
      134, 199, 73, 237, 56, 116, 110, 135, 36, 40, 14, 167, 50, 71, 81, 9, 178,
      54, 182, 247, 64, 32, 204, 116, 92, 131, 40, 30, 246, 188, 236, 182, 187,
      132, 239, 124, 136, 238, 146, 137, 247, 87, 52, 15, 78, 108, 135, 178,
      101, 70, 199, 193, 192, 144, 196, 106, 186, 141, 42, 101, 214, 196, 67,
      175, 38, 8, 189, 148, 166, 253, 221, 144, 119, 81, 1, 232, 175, 81, 237,
      13, 188, 220, 230, 47, 115, 184, 179, 0, 51, 118, 39, 22, 114, 232, 88,
      15, 121, 216, 130, 107, 173, 108, 175, 225, 113, 40, 223, 185, 6, 244,
      227, 73, 38, 64, 84, 10, 200, 53, 81, 179, 217, 106, 172, 59, 161, 70,
      180, 70, 48, 56, 46, 233, 133, 245, 57, 120, 154, 167, 49, 109, 188, 152,
      245, 181, 1, 159, 247, 44, 167, 152, 6, 191, 246, 38, 120, 141, 57, 241,
      168, 60, 38, 6, 82, 248, 87, 85, 0, 10, 22, 19, 44, 178, 63, 38, 78, 1,
      210, 166, 140, 3, 199, 112, 135, 155, 36, 13, 204, 124, 47, 5, 190, 103,
      91, 205, 147, 248, 115, 177, 196, 180, 234, 85, 35, 24, 182, 16, 207, 107,
      167, 10, 54, 193, 146, 71, 95, 45, 109, 184, 43, 101, 155, 184, 55, 171,
      196, 136, 89, 227, 84, 183, 31, 0, 137, 230, 146, 250, 6, 27, 225, 241,
      11, 95, 124, 248, 133, 171, 149, 67, 73, 19, 110, 104, 173, 86, 6, 246,
      195, 196, 200, 175, 53, 18, 198, 223, 140, 85, 208, 253, 204, 220, 255,
      232, 88, 238, 20, 97, 24, 52, 13, 3, 179, 62, 151, 101, 67, 33, 79, 253,
      157, 253, 233, 197, 109, 130, 78, 11, 165, 214, 200, 41, 157, 63, 46, 175,
      251, 246, 225, 227, 199, 92, 107, 216, 58, 124, 226, 202, 153, 92, 31,
      250, 182, 92, 99, 0, 110, 18, 78, 228, 166, 190, 67, 88, 245, 155, 139,
      82, 152, 39, 204, 74, 140, 95, 82, 82, 160, 147, 144, 33, 0, 242, 200, 22,
      102, 160, 233, 102, 224, 42, 205, 240, 56, 95, 197, 226, 175, 235, 240,
      125, 10, 51, 12, 246, 150, 234, 173, 95, 132, 173, 174, 1, 161, 23, 39,
      52, 168, 87, 54, 4, 66, 201, 34, 155, 82, 133, 170, 76, 52, 226, 109, 163,
      19, 34, 184, 226, 39, 20, 75, 72, 201, 70, 188, 71, 182, 230, 6, 19, 255,
      8, 145, 193, 63, 81, 150, 24, 72, 89, 168, 74, 98, 173, 133, 67, 227, 44,
      252, 252, 227, 192, 125, 20, 227, 144, 24, 31, 48, 67, 67, 48, 94, 163,
      52, 219, 163, 225, 214, 214, 109, 211, 122, 213, 198, 90, 204, 40, 97,
      211, 121, 17, 28, 132, 246, 110, 230, 51, 197, 42, 162, 143, 199, 158,
      215, 210, 133, 60, 65, 127, 1, 153, 193, 22, 171, 250, 114, 204, 246, 255,
      126, 25, 96, 44, 164, 102, 172, 211, 23, 245, 122, 48, 221, 249, 138, 148,
      134, 206, 135, 246, 42, 235, 198, 89, 189, 45, 125, 204, 69, 193, 48, 29,
      144, 125, 224, 127, 66, 1, 134, 141, 224, 211, 193, 141, 69, 128, 75, 167,
      244, 160, 120, 54, 191, 214, 29, 40, 249, 15, 46, 68, 141, 91, 242, 91,
      80, 252, 109, 122, 154, 64, 153, 56, 65, 254, 106, 18, 4, 172, 171, 136,
      80, 98, 79, 133, 255, 4, 100, 191, 144, 171, 219, 46, 132, 181, 130, 228,
      107, 68, 32, 123, 201, 17, 67, 35, 144, 180, 160, 30, 125, 9, 55, 184,
      172, 0, 159, 250, 232, 83, 168, 162, 102, 158, 121, 208, 177, 116, 163,
      160, 80, 241, 46, 156, 58, 203, 240, 67, 176, 244, 170, 160, 115, 122,
      141, 154, 101, 218, 178, 119, 130, 195, 32, 207, 51, 149, 98, 51, 219, 57,
      121, 216, 156, 101, 218, 184, 220, 204, 41, 181, 149, 63, 80, 194, 11,
      143, 164, 219, 23, 123, 141, 119, 43, 94, 78, 175, 89, 165, 48, 167, 44,
      45, 219, 197, 15, 202, 118, 116, 245, 151, 218, 14, 199, 96, 27, 102, 206,
      198, 123, 222, 178, 210, 20, 200, 38, 25, 124, 58, 102, 92, 197, 107, 51,
      5, 236, 125, 173, 198, 113, 144, 108, 177, 22, 104, 223, 165, 39, 9, 84,
      87, 124, 80, 153, 8, 212, 76, 2, 28, 12, 90, 212, 129, 148, 212, 229, 63,
      29, 200, 113, 171, 154, 107, 189, 202, 22, 147, 7, 32, 253, 70, 37, 224,
      98, 199, 129, 21, 54, 49, 52, 124, 84, 40, 190, 194, 108, 73, 26, 15, 124,
      87, 87, 198, 217, 122, 127, 82, 167, 131, 59, 8, 172, 49, 162, 61, 64, 79,
      196, 205, 65, 110, 75, 130, 128, 197, 182, 251, 110, 141, 197, 184, 166,
      244, 246, 217, 20, 105, 85, 42, 80, 251, 77, 59, 204, 247, 179, 218, 181,
      124, 209, 4, 28, 118, 234, 145, 237, 140, 106, 54, 88, 82, 28, 235, 68,
      221, 109, 139, 11, 166, 182, 63, 142, 194, 255, 213, 219, 116, 158, 31,
      224, 119, 126, 232, 160, 144, 1, 177, 92, 219, 162, 49, 181, 116, 163,
      104, 245, 193, 188, 26, 172, 15, 190, 135, 207, 106, 246, 13, 132, 76,
      189, 160, 25, 123, 26, 20, 48, 203, 59, 209, 69, 235, 103, 253, 160, 108,
      83, 206, 70, 98, 0, 2, 57, 162, 202, 63, 45, 89, 173, 201, 254, 254, 253,
      143, 21, 77, 131, 184, 234, 37, 68, 206, 69, 186, 179, 145, 147, 135, 42,
      137, 152, 253, 213, 240, 13, 122, 161, 218, 186, 180, 213, 162, 150, 231,
      63, 112, 182, 233, 86, 12, 225, 195, 133, 37, 28, 22, 147, 201, 200, 197,
      115, 3, 138, 194, 86, 79, 247, 27, 241, 149, 128, 197, 8, 11, 134, 53,
      118, 175, 248, 253, 114, 91, 31, 192, 253, 209, 111, 31, 228, 244, 184,
      179, 146, 145, 167, 137, 155, 184, 218, 38, 62, 187, 22, 181, 193, 93, 16,
      9, 195, 42, 198, 225, 100, 144, 148, 223, 184, 40, 117, 32, 131, 94, 93,
      83, 88, 125, 95, 220, 20, 206, 7, 228, 78, 54, 238, 178, 196, 38, 245, 95,
      8, 235, 106, 17, 175, 142, 193, 60, 179, 53, 244, 92, 147, 244, 218, 95,
      127, 251, 128, 42, 105, 82, 243, 224, 213, 25, 91, 151, 22, 201, 18, 25,
      230, 165, 85, 25, 249, 170, 160, 171, 210, 209, 32, 154, 124, 245, 60, 30,
      255, 138, 154, 29, 85, 156, 232, 177, 78, 14, 137, 52, 215, 247, 26, 211,
      115, 72, 20, 133, 232, 1, 151, 251, 63, 45, 120, 69, 49, 209, 130, 255, 2,
      218, 21, 251, 16, 86, 30, 62, 136, 92, 149, 60, 6, 125, 129, 145, 235,
      102, 190, 144, 248, 1, 53, 135, 21, 158, 44, 158, 230, 246, 172, 249, 161,
      105, 204, 49, 60, 70, 63, 127, 163, 231, 175, 174, 234, 147, 185, 62, 5,
      244, 156, 4, 31, 39, 156, 176, 154, 251, 166, 143, 212, 43, 30, 97, 50,
      37, 176, 155, 77, 149, 102,
    ]),
    'raw-public': hexStringToUint8Array(
      'd8b1e93c9718f642afa1c07609b157e805d831fefba033d8faabe5689575876b05eff4a7533931991d876c8a75ec7841594111c97f93f667eecc1953f01dad7f8c0158282b8633137d83e032a75214d9d7a2295fd73882e2b1d814a985558c0969ac36790057ca125d6093677fa43fc56131e67d35504014ef1d5a7666ddb106dcdcaa6b6b128a7d8a46423cb9e8d10464117618b56ef132fa8ad11354dc3d6050805165a009053521703c3bc34f73be655d38ab923352e942e1e2d3483a094adeb9afd39ca444bc772e0e40a00dcf3c51446c943b58585c58abf9cca089deeaa8e90356e0ae69e001b1b8e6ec1e55f93869d33253a88b1cafb51659a6d798dab86f41185247b964ac42b206d7a4fc3828c6cf986ebacf27ebb326d758696db1825b05dfa44ef1b07dc55e6428d6fbeffd589a0e4bfe5ed256f4335fa88bd5495797d1967e5845fb749d7a60d4ce2ada2655b832f6bc23483ce29bf656d16e85a1817e509aee4040aa9cb1e134572a589aaef61e548fdd331b413c2816782a912252eb4f14d7d3e7976c773574be0d8bc7bd5436bade5a74fde3cf68d1762a905e16dbc6d3d8ab4bf53df09d6c5113ee2778d2f23f7e060f1261e8cfb854ef48735a5f704e2dc90d66d09792fd99b1730ec2b86b76783f6959903cf2506a200bccaaa5ddb61fbb9fd876dacfb66b88d3a2e7c48053fbc0bd9501f524929f0b741ebf8db69de35b5848e037c360f587f98e10e5ed1b3c025b8a52c5d228087baccacf77c7be66288dae5dd3db86691a6764663e82e087ad52e0c8d54cd326b51061634b0e2aa2dfed8d011d8cbf9231ecb358cadc7cefe78365866f1c3697ac43a77160cc3f4ca95f0eaf95bdad27b166179e66ece046cbbe84e688031cc98394a4dbb5d01aef6f562366857271b4b852b46a7cf87e57b1a5b0cc808db38d2277a039cea85fc56e4f3c30aa7dce93899c552e07c1e496162e9333999df897fd723a7e267f13e163b7ebaf5aa608e98d0a55e893071489f054e7568632d4c906fd129672a08c02febd980e446e3286c749ed38746e8724280ea732475109b236b6f74020cc745c83281ef6bcecb6bb84ef7c88ee9289f757340f4e6c87b26546c7c1c090c46aba8d2a65d6c443af2608bd94a6fddd90775101e8af51ed0dbcdce62f73b8b3003376271672e8580f79d8826bad6cafe17128dfb906f4e3492640540ac83551b3d96aac3ba146b44630382ee985f539789aa7316dbc98f5b5019ff72ca79806bff626788d39f1a83c260652f85755000a16132cb23f264e01d2a68c03c770879b240dcc7c2f05be675bcd93f873b1c4b4ea552318b610cf6ba70a36c192475f2d6db82b659bb837abc48859e354b71f0089e692fa061be1f10b5f7cf885ab954349136e68ad5606f6c3c4c8af3512c6df8c55d0fdccdcffe858ee146118340d03b33e976543214ffd9dfde9c56d824e0ba5d6c8299d3f2eaffbf6e1e3c75c6bd83a7ce2ca995c1ffab65c63006e124ee4a6be4358f59b8b529827cc4a8c5f5252a093902100f2c81666a0e966e02acdf0385fc5e2afebf07d0a330cf696eaad5f84adae01a1172734a857360442c9229b5285aa4c34e26da31322b8e227144b48c946bc47b6e60613ff0891c13f5196184859a84a62ad8543e32cfcfce3c07d14e390181f304343305ea334dba3e1d6d66dd37ad5c65acc2861d379111c84f66ee633c52aa28fc79ed7d2853c417f0199c116abfa72ccf6ff7e19602ca466acd317f57a30ddf98a9486ce87f62aebc659bd2d7dcc45c1301d907de07f4201868de0d3c18d45804ba7f4a07836bfd61d28f90f2e448d5bf25b50fc6d7a9a40993841fe6a1204acab8850624f85ff0464bf90abdb2e84b582e46b44207bc911432390b4a01e7d0937b8ac009ffae853a8a2669e79d0b174a3a050f12e9c3acbf043b0f4aaa0737a8d9a65dab27782c320cf33956233db3979d89c65dab8dccc29b5953f50c20b8fa4db177b8d772b5e4eaf59a530a72c2ddbc50fca7674f597da0ec7601b66cec67bdeb2d214c826197c3a665cc56b3305ec7dadc671906cb11668dfa5270954577c509908d44c021c0c5ad48194d4e53f1dc871ab9a6bbdca16930720fd4625e062c781153631347c5428bec26c491a0f7c5757c6d97a7f52a7833b08ac31a23d404fc4cd416e4b8280c5b6fb6e8dc5b8a6f4f6d91469552a50fb4d3bccf7b3dab57cd1041c76ea91ed8c6a3658521ceb44dd6d8b0ba6b63f8ec2ffd5db749e1fe0777ee8a09001b15cdba231b574a368f5c1bc1aac0fbe87cf6af60d844cbda0197b1a1430cb3bd145eb67fda06c53ce4662000239a2ca3f2d59adc9fefefd8f154d83b8ea2544ce45bab39193872a8998fdd5f00d7aa1dabab4d5a296e73f70b6e9560ce1c385251c1693c9c8c573038ac2564ff71bf19580c5080b863576aff8fd725b1fc0fdd16f1fe4f4b8b39291a7899bb8da263ebb16b5c15d1009c32ac6e1649094dfb8287520835e5d53587d5fdc14ce07e44e36eeb2c426f55f08eb6a11af8ec13cb335f45c93f4da5f7ffb802a6952f3e0d5195b9716c91219e6a55519f9aaa0abd2d1209a7cf53c1eff8a9a1d559ce8b14e0e8934d7f71ad373481485e80197fb3f2d784531d182ff02da15fb10561e3e885c953c067d8191eb66be90f8013587159e2c9ee6f6acf9a169cc313c463f7fa3e7afaeea93b93e05f49c041f279cb09afba68fd42b1e613225b09b4d9566'
    ),
    'raw-seed': new Uint8Array([
      132, 164, 137, 75, 123, 70, 164, 178, 3, 156, 206, 16, 195, 26, 133, 186,
      176, 195, 102, 48, 254, 35, 29, 66, 103, 17, 67, 152, 38, 7, 130, 139,
    ]),
    jwk: {
      priv: 'hKSJS3tGpLIDnM4QwxqFurDDZjD-Ix1CZxFDmCYHgos',
      kty: 'AKP',
      alg: 'ML-DSA-65',
      pub: '2LHpPJcY9kKvocB2CbFX6AXYMf77oDPY-qvlaJV1h2sF7_SnUzkxmR2HbIp17HhBWUERyX-T9mfuzBlT8B2tf4wBWCgrhjMTfYPgMqdSFNnXoilf1ziC4rHYFKmFVYwJaaw2eQBXyhJdYJNnf6Q_xWEx5n01UEAU7x1admbdsQbc3KpraxKKfYpGQjy56NEEZBF2GLVu8TL6itETVNw9YFCAUWWgCQU1IXA8O8NPc75lXTirkjNS6ULh4tNIOglK3rmv05ykRLx3Lg5AoA3PPFFEbJQ7WFhcWKv5zKCJ3uqo6QNW4K5p4AGxuObsHlX5OGnTMlOoixyvtRZZpteY2rhvQRhSR7lkrEKyBtek_Dgoxs-YbrrPJ-uzJtdYaW2xglsF36RO8bB9xV5kKNb77_1Ymg5L_l7SVvQzX6iL1UlXl9GWflhF-3SdemDUziraJlW4Mva8I0g84pv2VtFuhaGBflCa7kBAqpyx4TRXKliarvYeVI_dMxtBPCgWeCqRIlLrTxTX0-eXbHc1dL4Ni8e9VDa63lp0_ePPaNF2KpBeFtvG09irS_U98J1sURPuJ3jS8j9-Bg8SYejPuFTvSHNaX3BOLckNZtCXkv2ZsXMOwrhrdng_aVmQPPJQaiALzKql3bYfu5_YdtrPtmuI06LnxIBT-8C9lQH1JJKfC3Qev422neNbWEjgN8Ng9Yf5jhDl7Rs8AluKUsXSKAh7rMrPd8e-ZiiNrl3T24ZpGmdkZj6C4IetUuDI1UzTJrUQYWNLDiqi3-2NAR2Mv5Ix7LNYytx87-eDZYZvHDaXrEOncWDMP0ypXw6vlb2tJ7FmF55m7OBGy76E5ogDHMmDlKTbtdAa729WI2aFcnG0uFK0anz4flexpbDMgI2zjSJ3oDnOqF_Fbk88MKp9zpOJnFUuB8HklhYukzOZnfiX_XI6fiZ_E-Fjt-uvWqYI6Y0KVeiTBxSJ8FTnVoYy1MkG_RKWcqCMAv69mA5EbjKGx0ntOHRuhyQoDqcyR1EJsja290AgzHRcgyge9rzstruE73yI7pKJ91c0D05sh7JlRsfBwJDEarqNKmXWxEOvJgi9lKb93ZB3UQHor1HtDbzc5i9zuLMAM3YnFnLoWA952IJrrWyv4XEo37kG9ONJJkBUCsg1UbPZaqw7oUa0RjA4LumF9Tl4mqcxbbyY9bUBn_csp5gGv_YmeI058ag8JgZS-FdVAAoWEyyyPyZOAdKmjAPHcIebJA3MfC8FvmdbzZP4c7HEtOpVIxi2EM9rpwo2wZJHXy1tuCtlm7g3q8SIWeNUtx8AieaS-gYb4fELX3z4hauVQ0kTbmitVgb2w8TIrzUSxt-MVdD9zNz_6FjuFGEYNA0Dsz6XZUMhT_2d_enFbYJOC6XWyCmdPy6v-_bh48dca9g6fOLKmVwf-rZcYwBuEk7kpr5DWPWbi1KYJ8xKjF9SUqCTkCEA8sgWZqDpZuAqzfA4X8Xir-vwfQozDPaW6q1fhK2uAaEXJzSoVzYEQskim1KFqkw04m2jEyK44icUS0jJRrxHtuYGE_8IkcE_UZYYSFmoSmKthUPjLPz848B9FOOQGB8wQ0MwXqM026Ph1tZt03rVxlrMKGHTeREchPZu5jPFKqKPx57X0oU8QX8BmcEWq_pyzPb_fhlgLKRmrNMX9Xow3fmKlIbOh_Yq68ZZvS19zEXBMB2QfeB_QgGGjeDTwY1FgEun9KB4Nr_WHSj5Dy5EjVvyW1D8bXqaQJk4Qf5qEgSsq4hQYk-F_wRkv5Cr2y6EtYLka0Qge8kRQyOQtKAefQk3uKwAn_roU6iiZp550LF0o6BQ8S6cOsvwQ7D0qqBzeo2aZdqyd4LDIM8zlWIz2zl52Jxl2rjczCm1lT9QwguPpNsXe413K15Or1mlMKcsLdvFD8p2dPWX2g7HYBtmzsZ73rLSFMgmGXw6ZlzFazMF7H2txnGQbLEWaN-lJwlUV3xQmQjUTAIcDFrUgZTU5T8dyHGrmmu9yhaTByD9RiXgYseBFTYxNHxUKL7CbEkaD3xXV8bZen9Sp4M7CKwxoj1AT8TNQW5LgoDFtvtujcW4pvT22RRpVSpQ-007zPez2rV80QQcduqR7YxqNlhSHOtE3W2LC6a2P47C_9XbdJ4f4Hd-6KCQAbFc26IxtXSjaPXBvBqsD76Hz2r2DYRMvaAZexoUMMs70UXrZ_2gbFPORmIAAjmiyj8tWa3J_v79jxVNg7jqJUTORbqzkZOHKomY_dXwDXqh2rq01aKW5z9wtulWDOHDhSUcFpPJyMVzA4rCVk_3G_GVgMUIC4Y1dq_4_XJbH8D90W8f5PS4s5KRp4mbuNomPrsWtcFdEAnDKsbhZJCU37godSCDXl1TWH1f3BTOB-RONu6yxCb1XwjrahGvjsE8szX0XJP02l9_-4AqaVLz4NUZW5cWyRIZ5qVVGfmqoKvS0SCafPU8Hv-Kmh1VnOixTg6JNNf3GtNzSBSF6AGX-z8teEUx0YL_AtoV-xBWHj6IXJU8Bn2BketmvpD4ATWHFZ4snub2rPmhacwxPEY_f6Pnr67qk7k-BfScBB8nnLCa-6aP1CseYTIlsJtNlWY',
    },
  },
  'ML-DSA-87': {
    privateUsages: ['sign'],
    publicUsages: ['verify'],
    pkcs8: new Uint8Array([
      48, 52, 2, 1, 0, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 3, 19, 4, 34,
      128, 32, 161, 80, 109, 145, 76, 109, 101, 140, 117, 39, 228, 51, 151, 221,
      109, 76, 37, 246, 164, 121, 116, 51, 90, 76, 208, 59, 254, 105, 131, 68,
      18, 81,
    ]),
    spki: new Uint8Array([
      48, 130, 10, 50, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 3, 19, 3, 130,
      10, 33, 0, 146, 184, 67, 40, 172, 27, 204, 27, 135, 22, 109, 223, 127, 23,
      97, 130, 198, 228, 199, 62, 178, 21, 173, 20, 88, 180, 205, 168, 17, 164,
      135, 92, 85, 146, 76, 194, 152, 80, 239, 157, 33, 21, 239, 182, 176, 254,
      124, 80, 135, 138, 87, 169, 103, 99, 87, 5, 91, 161, 239, 59, 18, 246,
      148, 20, 32, 60, 117, 245, 182, 156, 196, 230, 82, 117, 228, 211, 81, 45,
      115, 217, 23, 95, 138, 95, 103, 124, 32, 89, 187, 48, 251, 103, 81, 234,
      76, 4, 57, 197, 71, 48, 125, 169, 195, 147, 183, 142, 166, 8, 147, 7, 77,
      240, 111, 44, 168, 23, 89, 107, 95, 220, 75, 202, 44, 25, 244, 200, 160,
      0, 174, 111, 107, 204, 22, 36, 122, 191, 101, 33, 52, 252, 14, 47, 25,
      109, 135, 48, 131, 253, 195, 237, 60, 86, 14, 119, 85, 28, 182, 139, 136,
      191, 59, 187, 90, 126, 207, 168, 238, 184, 83, 77, 254, 208, 21, 57, 104,
      188, 228, 134, 82, 249, 190, 249, 163, 120, 111, 68, 225, 210, 131, 29,
      151, 153, 146, 71, 163, 104, 225, 194, 33, 64, 213, 92, 145, 253, 42, 32,
      233, 95, 224, 72, 184, 119, 192, 113, 253, 177, 153, 246, 240, 49, 103,
      170, 229, 82, 69, 186, 36, 252, 29, 124, 255, 25, 148, 5, 160, 159, 105,
      157, 185, 25, 158, 122, 145, 30, 245, 51, 205, 62, 56, 154, 23, 52, 0,
      225, 177, 105, 195, 131, 177, 151, 197, 114, 110, 128, 227, 127, 176, 28,
      252, 217, 56, 61, 136, 148, 190, 124, 108, 129, 62, 243, 235, 37, 70, 228,
      233, 10, 67, 124, 120, 58, 164, 83, 57, 80, 39, 204, 98, 28, 199, 136, 75,
      12, 51, 255, 24, 130, 127, 19, 239, 160, 94, 137, 75, 15, 82, 158, 252,
      163, 43, 236, 193, 234, 27, 74, 69, 14, 179, 171, 10, 169, 27, 138, 172,
      213, 189, 222, 167, 110, 24, 11, 118, 151, 223, 94, 154, 125, 9, 21, 137,
      70, 128, 51, 102, 52, 105, 104, 157, 54, 186, 75, 217, 226, 169, 71, 125,
      177, 253, 218, 85, 236, 242, 25, 215, 147, 181, 104, 242, 82, 75, 50, 165,
      49, 102, 128, 82, 237, 170, 134, 162, 196, 56, 247, 199, 138, 102, 118,
      37, 66, 114, 165, 177, 156, 251, 39, 199, 12, 167, 246, 169, 150, 108, 91,
      192, 42, 68, 192, 244, 255, 107, 18, 191, 7, 73, 19, 174, 28, 116, 66,
      131, 96, 173, 60, 131, 190, 249, 219, 246, 71, 182, 124, 183, 129, 101,
      109, 95, 180, 78, 17, 140, 182, 62, 80, 195, 184, 253, 176, 169, 153, 1,
      29, 83, 39, 252, 150, 41, 219, 176, 48, 151, 108, 60, 255, 239, 0, 85,
      101, 193, 110, 204, 12, 254, 22, 136, 15, 154, 217, 88, 13, 28, 252, 232,
      48, 32, 33, 41, 221, 103, 227, 228, 177, 54, 175, 195, 106, 174, 140, 54,
      128, 108, 214, 228, 215, 118, 226, 206, 171, 21, 155, 162, 152, 135, 203,
      16, 170, 130, 100, 173, 155, 243, 80, 40, 98, 157, 248, 7, 101, 88, 199,
      218, 224, 141, 82, 238, 121, 92, 82, 97, 49, 31, 155, 61, 63, 84, 227, 90,
      143, 164, 59, 216, 101, 19, 35, 134, 2, 20, 18, 197, 97, 215, 169, 85,
      220, 75, 254, 91, 125, 144, 43, 65, 128, 29, 66, 77, 184, 172, 89, 123,
      203, 231, 254, 59, 18, 249, 204, 249, 220, 153, 84, 166, 63, 23, 108, 120,
      145, 216, 67, 223, 123, 248, 15, 253, 63, 191, 126, 84, 95, 98, 141, 66,
      200, 129, 194, 174, 30, 80, 48, 75, 113, 14, 102, 101, 218, 249, 14, 203,
      24, 6, 11, 89, 99, 56, 49, 17, 148, 160, 242, 101, 191, 102, 227, 115, 33,
      107, 71, 235, 6, 141, 68, 161, 162, 165, 227, 159, 82, 253, 54, 157, 214,
      255, 141, 151, 154, 134, 150, 93, 141, 97, 158, 244, 180, 135, 42, 10, 3,
      148, 9, 152, 149, 20, 18, 237, 253, 180, 136, 165, 13, 80, 195, 220, 43,
      3, 178, 10, 127, 144, 2, 207, 209, 246, 40, 110, 38, 133, 9, 22, 180, 11,
      223, 116, 236, 205, 186, 25, 183, 155, 165, 77, 206, 101, 255, 106, 223,
      70, 10, 22, 176, 119, 142, 163, 197, 178, 251, 216, 112, 237, 63, 201, 77,
      219, 196, 2, 176, 48, 15, 207, 91, 74, 236, 21, 8, 205, 126, 77, 28, 13,
      26, 28, 202, 250, 100, 79, 134, 209, 193, 78, 202, 58, 248, 124, 215, 64,
      143, 244, 17, 23, 163, 162, 241, 249, 49, 210, 168, 203, 213, 135, 77, 14,
      29, 35, 193, 234, 58, 12, 106, 165, 163, 251, 192, 115, 251, 7, 198, 189,
      93, 207, 178, 246, 50, 189, 185, 51, 45, 84, 140, 194, 34, 46, 92, 90,
      136, 81, 81, 53, 52, 253, 128, 247, 131, 243, 21, 207, 245, 141, 49, 178,
      213, 214, 211, 8, 17, 234, 133, 225, 104, 197, 186, 224, 117, 1, 173, 104,
      17, 177, 161, 223, 71, 195, 159, 194, 45, 177, 116, 26, 187, 193, 161,
      213, 179, 158, 8, 122, 186, 122, 191, 158, 5, 12, 178, 235, 78, 132, 78,
      189, 16, 86, 110, 73, 51, 129, 255, 242, 110, 63, 6, 53, 209, 110, 132,
      236, 43, 239, 192, 221, 138, 1, 128, 176, 0, 113, 85, 119, 201, 36, 188,
      202, 9, 223, 98, 196, 42, 130, 158, 149, 200, 150, 202, 132, 118, 153, 97,
      54, 195, 154, 15, 45, 246, 129, 144, 255, 231, 75, 25, 56, 47, 178, 98,
      10, 106, 84, 56, 113, 161, 227, 37, 246, 1, 245, 129, 173, 70, 186, 11,
      28, 125, 198, 243, 225, 113, 130, 5, 138, 52, 251, 194, 152, 105, 48, 214,
      13, 246, 228, 75, 236, 194, 223, 177, 64, 150, 97, 167, 20, 27, 74, 76,
      166, 199, 239, 91, 240, 8, 22, 54, 41, 63, 35, 112, 255, 251, 88, 252,
      147, 173, 185, 43, 98, 83, 155, 230, 176, 55, 161, 8, 83, 15, 110, 151,
      241, 110, 168, 203, 190, 198, 218, 152, 144, 150, 58, 123, 11, 123, 250,
      104, 113, 198, 93, 1, 152, 51, 172, 140, 246, 115, 113, 229, 218, 166,
      200, 35, 123, 16, 133, 169, 191, 59, 103, 12, 114, 15, 60, 37, 4, 92, 208,
      54, 31, 79, 56, 225, 6, 11, 74, 107, 79, 225, 239, 16, 73, 249, 234, 197,
      129, 230, 97, 39, 115, 49, 96, 141, 41, 242, 225, 177, 214, 18, 103, 34,
      229, 37, 176, 241, 99, 82, 227, 195, 77, 32, 64, 4, 120, 49, 199, 209,
      139, 2, 4, 222, 233, 45, 151, 141, 142, 252, 41, 124, 231, 13, 144, 63,
      212, 252, 145, 34, 142, 232, 152, 84, 135, 87, 175, 46, 53, 139, 60, 168,
      135, 167, 101, 253, 127, 152, 138, 154, 31, 231, 198, 77, 89, 182, 9, 54,
      103, 119, 100, 218, 245, 44, 191, 74, 30, 152, 84, 22, 62, 159, 131, 163,
      223, 3, 51, 194, 241, 49, 9, 213, 43, 214, 201, 75, 158, 198, 22, 203,
      209, 190, 199, 189, 75, 4, 6, 72, 60, 241, 113, 171, 30, 42, 143, 73, 51,
      72, 206, 110, 175, 203, 195, 199, 15, 155, 208, 166, 121, 26, 132, 59, 44,
      72, 155, 7, 48, 122, 132, 224, 142, 3, 7, 21, 207, 11, 30, 112, 18, 149,
      146, 127, 41, 104, 197, 169, 86, 213, 108, 253, 111, 160, 5, 11, 202, 172,
      233, 32, 5, 52, 92, 124, 152, 162, 11, 88, 28, 166, 248, 141, 251, 38,
      161, 53, 49, 136, 246, 183, 85, 9, 165, 115, 108, 18, 208, 218, 129, 165,
      163, 131, 34, 32, 94, 226, 121, 93, 24, 87, 226, 105, 25, 242, 128, 198,
      78, 26, 237, 21, 92, 33, 121, 8, 119, 131, 140, 193, 14, 60, 139, 130, 19,
      65, 96, 50, 5, 249, 12, 27, 51, 23, 195, 89, 255, 47, 23, 109, 62, 202,
      190, 5, 131, 92, 91, 39, 27, 209, 132, 146, 95, 98, 66, 26, 230, 186, 236,
      186, 162, 149, 81, 143, 221, 21, 79, 171, 236, 21, 161, 19, 135, 10, 213,
      168, 200, 135, 19, 221, 177, 207, 106, 214, 194, 124, 220, 53, 45, 176,
      245, 178, 189, 49, 242, 22, 230, 154, 241, 146, 230, 187, 180, 244, 158,
      145, 197, 225, 51, 150, 140, 26, 175, 78, 142, 243, 232, 221, 137, 205,
      130, 178, 54, 216, 136, 118, 212, 33, 90, 206, 18, 224, 158, 44, 23, 144,
      204, 24, 184, 48, 81, 233, 124, 20, 222, 77, 119, 144, 22, 145, 241, 19,
      206, 135, 252, 164, 114, 84, 37, 175, 107, 67, 243, 183, 137, 213, 53,
      236, 41, 73, 50, 34, 146, 218, 204, 68, 235, 158, 150, 139, 133, 75, 248,
      157, 7, 0, 53, 68, 44, 156, 110, 56, 197, 209, 201, 0, 155, 225, 85, 35,
      169, 193, 231, 36, 31, 142, 101, 168, 29, 192, 31, 128, 81, 191, 253, 184,
      153, 226, 214, 1, 27, 6, 0, 192, 36, 101, 72, 105, 150, 226, 3, 21, 12,
      127, 72, 250, 223, 240, 136, 249, 157, 129, 247, 91, 178, 157, 208, 86,
      146, 23, 176, 150, 35, 211, 155, 22, 207, 119, 168, 167, 122, 180, 183,
      106, 97, 138, 87, 96, 34, 141, 110, 145, 231, 226, 35, 115, 232, 129, 54,
      186, 128, 190, 238, 37, 169, 194, 37, 24, 237, 211, 164, 111, 54, 88, 245,
      125, 67, 78, 194, 11, 194, 235, 217, 87, 203, 14, 220, 189, 107, 68, 94,
      139, 66, 230, 5, 54, 64, 28, 246, 143, 75, 127, 239, 243, 20, 251, 189,
      246, 246, 151, 90, 219, 227, 242, 223, 205, 40, 124, 245, 4, 189, 72, 39,
      145, 110, 96, 120, 164, 27, 117, 146, 177, 30, 76, 173, 106, 130, 228,
      192, 189, 59, 167, 30, 127, 178, 164, 5, 133, 80, 199, 207, 216, 189, 156,
      93, 222, 150, 129, 81, 193, 180, 38, 59, 8, 214, 210, 95, 150, 182, 175,
      148, 43, 153, 169, 66, 62, 135, 140, 159, 89, 195, 253, 3, 132, 180, 164,
      244, 243, 232, 71, 196, 200, 158, 194, 114, 115, 193, 88, 161, 185, 235,
      247, 14, 126, 225, 176, 111, 17, 79, 77, 245, 80, 229, 174, 6, 180, 156,
      217, 85, 174, 201, 255, 237, 85, 83, 53, 188, 153, 98, 91, 193, 21, 211,
      49, 145, 196, 252, 52, 66, 226, 131, 203, 214, 130, 237, 194, 208, 174,
      102, 133, 220, 235, 222, 79, 232, 36, 21, 161, 248, 51, 185, 164, 156, 95,
      121, 65, 57, 233, 183, 29, 199, 105, 104, 12, 90, 195, 186, 81, 199, 176,
      1, 87, 16, 226, 192, 206, 185, 197, 46, 34, 75, 174, 153, 238, 15, 50, 87,
      226, 96, 26, 197, 202, 73, 235, 19, 140, 9, 79, 12, 52, 83, 76, 85, 146,
      234, 24, 151, 179, 178, 118, 58, 162, 223, 103, 69, 244, 231, 135, 167,
      204, 117, 166, 60, 237, 82, 63, 11, 4, 207, 10, 146, 54, 126, 191, 79,
      133, 60, 128, 34, 136, 170, 23, 84, 81, 38, 94, 9, 130, 245, 100, 115,
      209, 34, 228, 158, 101, 216, 135, 208, 207, 191, 169, 115, 252, 144, 139,
      226, 252, 6, 44, 221, 134, 170, 87, 11, 46, 124, 58, 219, 179, 238, 6, 98,
      216, 18, 174, 42, 12, 97, 126, 85, 245, 81, 220, 232, 135, 114, 21, 125,
      135, 225, 182, 245, 228, 223, 242, 62, 158, 35, 76, 6, 110, 25, 184, 206,
      124, 237, 54, 252, 199, 44, 78, 89, 0, 135, 44, 176, 57, 168, 36, 221,
      173, 77, 214, 209, 60, 1, 202, 238, 237, 61, 90, 47, 114, 230, 92, 238,
      235, 18, 151, 220, 243, 225, 163, 159, 139, 189, 253, 62, 225, 182, 202,
      59, 7, 83, 99, 129, 118, 175, 37, 246, 85, 119, 251, 246, 69, 180, 247,
      37, 24, 194, 89, 158, 97, 230, 247, 254, 145, 102, 89, 77, 68, 245, 3,
      103, 83, 28, 45, 168, 30, 189, 151, 112, 120, 215, 84, 90, 198, 85, 85,
      129, 55, 127, 124, 28, 137, 229, 139, 54, 88, 229, 105, 81, 212, 83, 28,
      107, 250, 82, 164, 43, 24, 15, 57, 206, 156, 19, 145, 95, 57, 169, 8, 128,
      211, 29, 213, 195, 148, 27, 73, 186, 221, 242, 11, 167, 78, 246, 133, 18,
      118, 67, 236, 59, 19, 112, 254, 93, 168, 157, 118, 0, 107, 248, 57, 149,
      67, 222, 123, 225, 207, 251, 69, 218, 56, 110, 162, 19, 25, 209, 209, 213,
      200, 158, 70, 9, 100, 208, 77, 48, 255, 151, 200, 0, 68, 230, 70, 120,
      209, 29, 86, 225, 188, 189, 226, 101, 42, 176, 32, 147, 121, 72, 151, 130,
      217, 13, 66, 148, 84, 129, 215, 249, 164, 174, 187, 80, 85, 185, 245, 108,
      169, 119, 59, 178, 144, 229, 63, 194, 132, 250, 131, 82, 161, 125, 126,
      255, 252, 220, 204, 104, 231, 201, 136, 246, 116, 43, 88, 233, 0, 43, 128,
      214, 40, 59, 81, 147, 139, 132, 69, 24, 233, 21, 14, 91, 230, 241, 19,
      138, 163, 55, 13, 221, 47, 64, 140, 248, 6, 38, 164, 16, 219, 63, 33, 180,
      71, 151, 0, 234, 103, 58, 213, 222, 163, 95, 132, 1, 178, 146, 66, 124,
      242, 223, 102, 129, 192, 214, 194, 117, 162, 252, 246, 143, 42, 70, 139,
      97, 168, 64, 141, 190, 115, 126, 93, 175, 59, 49, 9, 184, 88, 201, 100,
      182, 142, 145, 244, 72, 128, 203, 49, 196, 5, 5, 18, 46, 34, 87, 171, 132,
      158, 128, 75, 194, 8, 242, 52, 156, 229, 245, 56, 245, 88, 14, 195, 110,
      166, 51, 158, 245, 195, 120, 17, 166, 66, 100, 212, 188, 243, 2, 236, 90,
      8, 16, 35, 151, 122, 175, 115, 168, 186, 191, 60, 71, 23, 81, 217, 79,
      203, 239, 61, 146, 247, 168, 112, 83, 102, 146, 222, 178, 45, 247, 63, 23,
      181, 3, 136, 208, 62, 154, 203, 35, 250, 238, 61, 98, 207, 90, 169, 175,
      36, 227, 9, 182, 78, 226, 99, 89, 67, 105, 185, 35, 242, 162, 54, 99, 60,
      148, 14, 118, 1, 26, 120, 62, 82, 62, 222, 34, 99, 58, 174, 145, 199, 190,
      21, 182, 117, 238, 13, 170, 29, 67, 149, 44, 90, 94, 181, 125, 182, 186,
      82, 55, 105, 253, 29, 212, 67, 134, 204, 227, 94, 255, 127, 72, 157, 140,
      142, 224, 77, 149, 29, 170, 45, 163, 214, 209, 46, 28, 125, 177, 111, 2,
      92, 121, 252, 166, 204, 227, 173, 51, 60, 162, 243, 202, 207, 103, 30,
      153, 182, 116, 182, 130, 98, 59, 25, 141, 239, 49, 224, 176, 27, 237, 218,
      76, 68, 189, 108, 185, 136, 255, 105, 150, 11, 153, 44, 248, 139, 199,
      178, 235, 85, 115, 121, 144, 87, 221, 50, 222, 238, 16, 20, 51, 190, 93,
      248, 228, 84, 228, 115, 31, 229, 227, 137, 180, 44, 115, 224, 119, 129,
      181, 134, 224, 144, 186, 123, 208, 118, 96, 101, 177, 191, 232, 171, 6,
      17, 247, 187, 173, 84, 70, 249, 19, 191, 116, 172, 126, 131, 216, 123,
      225, 151, 55, 205, 177, 93, 139, 117,
    ]),
    'raw-public': hexStringToUint8Array(
      '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'
    ),
    'raw-seed': new Uint8Array([
      161, 80, 109, 145, 76, 109, 101, 140, 117, 39, 228, 51, 151, 221, 109, 76,
      37, 246, 164, 121, 116, 51, 90, 76, 208, 59, 254, 105, 131, 68, 18, 81,
    ]),
    jwk: {
      priv: 'oVBtkUxtZYx1J-Qzl91tTCX2pHl0M1pM0Dv-aYNEElE',
      kty: 'AKP',
      alg: 'ML-DSA-87',
      pub: 'krhDKKwbzBuHFm3ffxdhgsbkxz6yFa0UWLTNqBGkh1xVkkzCmFDvnSEV77aw_nxQh4pXqWdjVwVboe87EvaUFCA8dfW2nMTmUnXk01Etc9kXX4pfZ3wgWbsw-2dR6kwEOcVHMH2pw5O3jqYIkwdN8G8sqBdZa1_cS8osGfTIoACub2vMFiR6v2UhNPwOLxlthzCD_cPtPFYOd1UctouIvzu7Wn7PqO64U03-0BU5aLzkhlL5vvmjeG9E4dKDHZeZkkejaOHCIUDVXJH9KiDpX-BIuHfAcf2xmfbwMWeq5VJFuiT8HXz_GZQFoJ9pnbkZnnqRHvUzzT44mhc0AOGxacODsZfFcm6A43-wHPzZOD2IlL58bIE-8-slRuTpCkN8eDqkUzlQJ8xiHMeISwwz_xiCfxPvoF6JSw9SnvyjK-zB6htKRQ6zqwqpG4qs1b3ep24YC3aX316afQkViUaAM2Y0aWidNrpL2eKpR32x_dpV7PIZ15O1aPJSSzKlMWaAUu2qhqLEOPfHimZ2JUJypbGc-yfHDKf2qZZsW8AqRMD0_2sSvwdJE64cdEKDYK08g7752_ZHtny3gWVtX7ROEYy2PlDDuP2wqZkBHVMn_JYp27Awl2w8_-8AVWXBbswM_haID5rZWA0c_OgwICEp3Wfj5LE2r8Nqrow2gGzW5Nd24s6rFZuimIfLEKqCZK2b81AoYp34B2VYx9rgjVLueVxSYTEfmz0_VONaj6Q72GUTI4YCFBLFYdepVdxL_lt9kCtBgB1CTbisWXvL5_47EvnM-dyZVKY_F2x4kdhD33v4D_0_v35UX2KNQsiBwq4eUDBLcQ5mZdr5DssYBgtZYzgxEZSg8mW_ZuNzIWtH6waNRKGipeOfUv02ndb_jZeahpZdjWGe9LSHKgoDlAmYlRQS7f20iKUNUMPcKwOyCn-QAs_R9ihuJoUJFrQL33TszboZt5ulTc5l_2rfRgoWsHeOo8Wy-9hw7T_JTdvEArAwD89bSuwVCM1-TRwNGhzK-mRPhtHBTso6-HzXQI_0ERejovH5MdKoy9WHTQ4dI8HqOgxqpaP7wHP7B8a9Xc-y9jK9uTMtVIzCIi5cWohRUTU0_YD3g_MVz_WNMbLV1tMIEeqF4WjFuuB1Aa1oEbGh30fDn8ItsXQau8Gh1bOeCHq6er-eBQyy606ETr0QVm5JM4H_8m4_BjXRboTsK-_A3YoBgLAAcVV3ySS8ygnfYsQqgp6VyJbKhHaZYTbDmg8t9oGQ_-dLGTgvsmIKalQ4caHjJfYB9YGtRroLHH3G8-FxggWKNPvCmGkw1g325Evswt-xQJZhpxQbSkymx-9b8AgWNik_I3D_-1j8k625K2JTm-awN6EIUw9ul_FuqMu-xtqYkJY6ewt7-mhxxl0BmDOsjPZzceXapsgjexCFqb87ZwxyDzwlBFzQNh9POOEGC0prT-HvEEn56sWB5mEnczFgjSny4bHWEmci5SWw8WNS48NNIEAEeDHH0YsCBN7pLZeNjvwpfOcNkD_U_JEijuiYVIdXry41izyoh6dl_X-Yipof58ZNWbYJNmd3ZNr1LL9KHphUFj6fg6PfAzPC8TEJ1SvWyUuexhbL0b7HvUsEBkg88XGrHiqPSTNIzm6vy8PHD5vQpnkahDssSJsHMHqE4I4DBxXPCx5wEpWSfyloxalW1Wz9b6AFC8qs6SAFNFx8mKILWBym-I37JqE1MYj2t1UJpXNsEtDagaWjgyIgXuJ5XRhX4mkZ8oDGThrtFVwheQh3g4zBDjyLghNBYDIF-QwbMxfDWf8vF20-yr4Fg1xbJxvRhJJfYkIa5rrsuqKVUY_dFU-r7BWhE4cK1ajIhxPdsc9q1sJ83DUtsPWyvTHyFuaa8ZLmu7T0npHF4TOWjBqvTo7z6N2JzYKyNtiIdtQhWs4S4J4sF5DMGLgwUel8FN5Nd5AWkfETzof8pHJUJa9rQ_O3idU17ClJMiKS2sxE656Wi4VL-J0HADVELJxuOMXRyQCb4VUjqcHnJB-OZagdwB-AUb_9uJni1gEbBgDAJGVIaZbiAxUMf0j63_CI-Z2B91uyndBWkhewliPTmxbPd6inerS3amGKV2AijW6R5-Ijc-iBNrqAvu4lqcIlGO3TpG82WPV9Q07CC8Lr2VfLDty9a0Rei0LmBTZAHPaPS3_v8xT7vfb2l1rb4_LfzSh89QS9SCeRbmB4pBt1krEeTK1qguTAvTunHn-ypAWFUMfP2L2cXd6WgVHBtCY7CNbSX5a2r5QrmalCPoeMn1nD_QOEtKT08-hHxMiewnJzwVihuev3Dn7hsG8RT031UOWuBrSc2VWuyf_tVVM1vJliW8EV0zGRxPw0QuKDy9aC7cLQrmaF3OveT-gkFaH4M7mknF95QTnptx3HaWgMWsO6UcewAVcQ4sDOucUuIkuume4PMlfiYBrFyknrE4wJTww0U0xVkuoYl7Oydjqi32dF9OeHp8x1pjztUj8LBM8KkjZ-v0-FPIAiiKoXVFEmXgmC9WRz0SLknmXYh9DPv6lz_JCL4vwGLN2GqlcLLnw627PuBmLYEq4qDGF-VfVR3OiHchV9h-G29eTf8j6eI0wGbhm4znztNvzHLE5ZAIcssDmoJN2tTdbRPAHK7u09Wi9y5lzu6xKX3PPho5-Lvf0-4bbKOwdTY4F2ryX2VXf79kW09yUYwlmeYeb3_pFmWU1E9QNnUxwtqB69l3B411RaxlVVgTd_fByJ5Ys2WOVpUdRTHGv6UqQrGA85zpwTkV85qQiA0x3Vw5QbSbrd8gunTvaFEnZD7DsTcP5dqJ12AGv4OZVD3nvhz_tF2jhuohMZ0dHVyJ5GCWTQTTD_l8gAROZGeNEdVuG8veJlKrAgk3lIl4LZDUKUVIHX-aSuu1BVufVsqXc7spDlP8KE-oNSoX1-__zczGjnyYj2dCtY6QArgNYoO1GTi4RFGOkVDlvm8ROKozcN3S9AjPgGJqQQ2z8htEeXAOpnOtXeo1-EAbKSQnzy32aBwNbCdaL89o8qRothqECNvnN-Xa87MQm4WMlkto6R9EiAyzHEBQUSLiJXq4SegEvCCPI0nOX1OPVYDsNupjOe9cN4EaZCZNS88wLsWggQI5d6r3Oour88RxdR2U_L7z2S96hwU2aS3rIt9z8XtQOI0D6ayyP67j1iz1qpryTjCbZO4mNZQ2m5I_KiNmM8lA52ARp4PlI-3iJjOq6Rx74VtnXuDaodQ5UsWl61fba6Ujdp_R3UQ4bM417_f0idjI7gTZUdqi2j1tEuHH2xbwJcefymzOOtMzyi88rPZx6ZtnS2gmI7GY3vMeCwG-3aTES9bLmI_2mWC5ks-IvHsutVc3mQV90y3u4QFDO-XfjkVORzH-XjibQsc-B3gbWG4JC6e9B2YGWxv-irBhH3u61URvkTv3SsfoPYe-GXN82xXYt1',
    },
  },
};
